﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GlassView : MonoBehaviour
{
    public Transform m_strawberry;//草莓
    public Transform m_lemon;//柠檬
    public Transform m_orange;//橙子
    public Transform m_effectPos;//特效位置
    public Vector3 effectPos => m_effectPos.position;

    private float m_strawberryOffest;
    private float m_lemonOffest;
    private float m_orangeOffest;

    private float m_strawberryNum;
    private float m_lemonNum;
    private float m_orangeNum;

    //private float m_strawberryMaxNum = 10.0f;
    //private float m_lemonMaxNum = 10.0f;
    //private float m_orangeMaxNum = 10.0f;

    private bool m_bControl = true;
    private float m_speed = 2.0f;

    private string m_strawberryAni = "juice_red";
    private string m_lemonAni = "juice_yellow";
    private string m_orangeAni = "juice_Orange";

    private float m_startPos = 0.28f;
    private float m_rateMod = 33.33f;
    private FruitView m_fruitView;

    private void Awake()
    {
        m_strawberry.gameObject.SetActive(false);
        m_lemon.gameObject.SetActive(false);
        if(m_orange)
        {
            m_orange.gameObject.SetActive(false);
        }
    }
    private void Start()
    {
        m_fruitView = BattleCtrl.instance.levelManager.curLevel.fruitView;
    }
    //数量
    public void SetFruitNum(int num1,int num2,int num3)
    {
        m_strawberryNum += num1;
        if (m_strawberryNum >= GlobalConfig.StrawberryRandomNum)
        {
            m_strawberryNum = GlobalConfig.StrawberryRandomNum;
            //BattleCtrl.instance.battleUI.SetStrawberryState(true);
        }
        m_lemonNum += num2;
        if(m_lemonNum >= GlobalConfig.LemonRandomNum)
        {
            m_lemonNum = GlobalConfig.LemonRandomNum;
            //BattleCtrl.instance.battleUI.SetLemonState(true);
        }
        m_orangeNum += num3;
        if(m_orangeNum >= GlobalConfig.OrangeRandomNum)
        {
            m_orangeNum = GlobalConfig.OrangeRandomNum;
            //BattleCtrl.instance.battleUI.SetOrangeState(true);
        }
        //BattleCtrl.instance.battleUI.SetStrawberryNum((int)m_strawberryNum);
        //BattleCtrl.instance.battleUI.SetLemonNum((int)m_lemonNum);
        //BattleCtrl.instance.battleUI.SetOrangeNum((int)m_orangeNum);
    }
    private void Update()
    {
        if (!BattleCtrl.instance.isStartBattle || BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        if (m_strawberryOffest < m_strawberryNum)
        {
            m_strawberry.gameObject.SetActive(true);
            m_strawberryOffest += Time.deltaTime * m_speed;

            Vector3 varSize = m_strawberry.localScale;
            varSize.y = m_strawberryOffest/ ((float)GlobalConfig.StrawberryRandomNum / 0.3f);
            m_strawberry.localScale = varSize;

            //草莓位置
            Vector3 varPosStrawberry = m_strawberry.localPosition;
            varPosStrawberry.y = m_startPos;
            m_strawberry.localPosition = varPosStrawberry;

            //柠檬位置
            Vector3 varPos = m_lemon.localPosition;
            varPos.y = m_startPos + m_strawberry.localScale.y * 2.0f;
            m_lemon.localPosition = varPos;

            //橙子位置
            if(m_orange)
            {
                Vector3 varOrangePos = m_orange.localPosition;
                varOrangePos.y = m_startPos + m_strawberry.localScale.y*2.0f
                    + m_lemon.localScale.y*2.0f;
                m_orange.localPosition = varOrangePos;
            }
            //m_fruitView.ShowAnimator(m_strawberryAni);
        }
        if(m_lemonOffest < m_lemonNum)
        {
            m_lemon.gameObject.SetActive(true);
            m_lemonOffest += Time.deltaTime * m_speed;

            Vector3 varSize = m_lemon.localScale;
            varSize.y = m_lemonOffest/ ((float)GlobalConfig.LemonRandomNum / 0.3f);
            m_lemon.localScale = varSize;

            Vector3 varPos = m_lemon.localPosition;
            varPos.y = m_startPos+m_strawberry.localScale.y*2.0f;
            m_lemon.localPosition = varPos;

            if (m_orange)
            {
                Vector3 varOrangePos = m_orange.localPosition;
                varOrangePos.y = m_startPos + m_strawberry.localScale.y*2.0f
                    + m_lemon.localScale.y*2.0f;
                m_orange.localPosition = varOrangePos;
            }
            //m_fruitView.ShowAnimator(m_lemonAni);
        }
        if (m_orangeOffest < m_orangeNum && m_orange)
        {
            m_orange.gameObject.SetActive(true);
            m_orangeOffest += Time.deltaTime * m_speed;

            Vector3 varSize = m_orange.localScale;
            varSize.y = m_orangeOffest/ ((float)GlobalConfig.OrangeRandomNum/0.3f);
            m_orange.localScale = varSize;

            Vector3 varPos = m_orange.localPosition;
            varPos.y = m_startPos+m_strawberry.localScale.y*2.0f
                + m_lemon.localScale.y*2.0f;
            m_orange.localPosition = varPos;
            //m_fruitView.ShowAnimator(m_orangeAni);
        }
        if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        {
            //if(m_strawberryOffest >= m_strawberryNum && m_lemonOffest >= m_lemonNum)
            //{
            //    m_fruitView.HideAnimator();
            //}
            if (m_strawberryOffest >= GlobalConfig.StrawberryRandomNum && m_lemonOffest >= GlobalConfig.LemonRandomNum
                && m_bControl)
            {
                m_bControl = false;
                BattleCtrl.instance.OnBattleWin();
            }
        }
        else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex
            || BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelThreeIndex)
        {
            //if (m_strawberryOffest >= m_strawberryNum && m_lemonOffest >= m_lemonNum
            //    && m_orangeOffest >= m_orangeNum)
            //{
            //    m_fruitView.HideAnimator();
            //}
            if (m_strawberryOffest >= GlobalConfig.StrawberryRandomNum && m_lemonOffest >= GlobalConfig.LemonRandomNum
                && m_orangeOffest >= GlobalConfig.OrangeRandomNum &&  m_bControl)
            {
                m_bControl = false;
                BattleCtrl.instance.OnBattleWin();
            }
        }
    }
}
